using namespace std;

#include <windows.h>
#include <GL/gl.h>
#include <GL/glext.h>

#include "BMP.h"
//#include <iostream>
#include <stdio.h>

STex loadBMP(const char *filename,bool colorKey,unsigned char trsp,unsigned char kr,unsigned char kg,unsigned char kb)
{
  STex res;
  res.w=res.h=0;
  res.ptr=NULL;
  
  FILE *f=fopen(filename,"rb");
  if(!f)return res;
  
  BMPHeader bh;
  BMPinfo bi;
  
  fread(&bh,sizeof(BMPHeader),1,f);
  if(bh.sign!=BMPSIGN)
  {
    fclose(f);
    return res;
  }
  fread(&bi,sizeof(BMPinfo),1,f);
  if(bi.bitPPixel!=24 || bi.compression!=0)
  {
    //fclose(f);
    //return res;
  }
  
  fseek(f,bh.offsetImage,SEEK_SET);
  
  GLubyte *pixels;
  
  if(colorKey)pixels=new GLubyte[bi.w*bi.h*4];
  else pixels=new GLubyte[bi.w*bi.h*3];
  
  if(!pixels)
  {
    fclose(f);
    return res;
  }
  
  GLubyte r,g,b;
  
  /*
  GLubyte *ptr=pixels;
  
  int i,j=bi.w*bi.h;

  for(i=0;i<j;i++)
  {
    fread(&b,sizeof(GLubyte),1,f);
    fread(&g,sizeof(GLubyte),1,f);
    fread(&r,sizeof(GLubyte),1,f);
    *ptr=r;ptr++;
    *ptr=g;ptr++;
    *ptr=b;ptr++;
  }
  */
  
  //Dans le BMP la premire ligne du fichier
  //est la dernire ligne de l'image
  //donc on inverse horizontalement en
  //partant du bas du buffer des pixels
  
  GLubyte *ptr;
  int j=bi.h-1,i;
  
  if(colorKey)
  {
      while(j>=0)
      {
        ptr=pixels+j*bi.w*4;//On accde  la ligne j
        for(i=0;i<bi.w;i++)
        {
          fread(&b,sizeof(GLubyte),1,f);
          fread(&g,sizeof(GLubyte),1,f);
          fread(&r,sizeof(GLubyte),1,f);
          
          *ptr=r;ptr++;
          *ptr=g;ptr++;
          *ptr=b;ptr++;
          if(r==kr && g==kg && b==kb){*ptr=0;ptr++;}
          else {*ptr=trsp;ptr++;}
        }
        j--;
      }
  }
  else
  {
      while(j>=0)
      {
        ptr=pixels+j*bi.w*3;//On accde  la ligne j
        for(i=0;i<bi.w;i++)
        {
          fread(&b,sizeof(GLubyte),1,f);
          fread(&g,sizeof(GLubyte),1,f);
          fread(&r,sizeof(GLubyte),1,f);
          
          *ptr=r;ptr++;
          *ptr=g;ptr++;
          *ptr=b;ptr++;
        }
        j--;
      }
  }
  
  res.w=bi.w;
  res.h=bi.h;
  res.ptr=pixels;
  
  //delete []pixels;
  
  fclose(f);
  
  return res;
}

/*
void clearTex(STex st)
{
 if(st.ptr)delete []st.ptr;
}
*/

GLuint makeTex2D_BMP(char *filenames,bool colorKey,unsigned char trsp,unsigned char r,unsigned char g,unsigned char b,bool rept)
{
    GLuint res;
    
    STex tmp=loadBMP(filenames,colorKey,trsp,r,g,b);
    if(tmp.h==0 || tmp.w==0)return 0xFFFFFFFF;
    
    glGenTextures( 1, &res );
    glBindTexture( GL_TEXTURE_2D, res );
    
    if(rept)
    {
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
    }
    else
    {
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP );
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP );
    }
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
    
    if(colorKey)glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA,tmp.w, tmp.h, 0, GL_RGBA, GL_UNSIGNED_BYTE, tmp.ptr );
    else glTexImage2D( GL_TEXTURE_2D, 0, GL_RGB,tmp.w, tmp.h, 0, GL_RGB, GL_UNSIGNED_BYTE, tmp.ptr );
    
    delete []tmp.ptr;
    
    return res;
}

GLuint makeTex3D_BMP(int nbTex,char *filenames[])
{
 /*
  glGenTextures( 1, &res );
  glBindTexture( GL_TEXTURE_2D, res );
  
  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
  
  glTexImage2D(GL_TEXTURE_2D,0, GL_RGB,
              bi.w,bi.h,0,
              GL_RGB,GL_UNSIGNED_BYTE,
              pixels);
              
  glBindTexture( GL_TEXTURE_2D, 0 );
  */
  
  if(nbTex<=0)return 0xFFFFFFFF;
  STex *ptrSt,*ptrSt2,*st=new STex[nbTex];
  int i,j,nbPx;
  
  ptrSt=st;
  for(i=0;i<nbTex;i++)
  {
   (*ptrSt)=loadBMP(filenames[i]);
   ptrSt++;
  }
  
  ptrSt=st;
  for(i=0;i<nbTex;i++)
  {
   if(!(ptrSt->ptr) || ptrSt->w<=0 || ptrSt->h<=0)goto err;
   
   ptrSt2=ptrSt+1;
   for(j=i+1;j<nbTex;j++)
   {
    if(ptrSt->w!=ptrSt2->w || ptrSt->h!=ptrSt2->h)goto err;
    ptrSt2++;
   }
    
   ptrSt++;
  }
  
  nbPx=(st->w)*(st->h)*3;
  
  GLubyte *ptrCur,*ptrT3,*pixels;
  
  ptrSt=st;
  pixels=ptrT3=new GLubyte[nbPx*nbTex];
  if(!pixels)goto err;
  for(i=0;i<nbTex;i++)
  {
   ptrCur=ptrSt->ptr;
   for(j=0;j<nbPx;j++)
   {
    (*ptrT3)=(*ptrCur);
    ptrT3++;
    ptrCur++;
   }
   delete []ptrSt->ptr;
   ptrSt++;
  }
  
  GLuint res;
 	// request 1 texture name from OpenGL
 	glGenTextures(1, &res);	
 	// tell OpenGL we're going to be setting up the texture name it gave us	
 	glBindTexture(GL_TEXTURE_3D, res);	
 	// when this texture needs to be shrunk to fit on small polygons, use linear interpolation of the texels to determine the color
 	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
 	// when this texture needs to be magnified to fit on a big polygon, use linear interpolation of the texels to determine the color
 	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
 	// we want the texture to repeat over the S axis, so if we specify coordinates out of range we still get textured.
 	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_WRAP_S, GL_REPEAT);
 	// same as above for T axis
 	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_WRAP_T, GL_REPEAT);
 	// same as above for R axis
 	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_WRAP_R, GL_CLAMP);
 	// this is a 3d texture, level 0 (max detail), GL should store it in RGB8 format, its WIDTHxHEIGHTxDEPTH in size, 
 	// it doesnt have a border, we're giving it to GL in RGB format as a series of unsigned bytes, and texels is where the texel data is.
 	PFNGLTEXIMAGE3DPROC glTexImage3D;
 	glTexImage3D = (PFNGLTEXIMAGE3DPROC)wglGetProcAddress("glTexImage3D");
  glTexImage3D(GL_TEXTURE_3D, 0, GL_RGB, st->w, st->h, nbTex, 0, GL_RGB, GL_UNSIGNED_BYTE, pixels);
  
  delete []st;
  delete []pixels;
  
  return res;
  
err:
    
  ptrSt=st;
  for(i=0;i<nbTex;i++)
  {
   if(ptrSt->ptr)delete []ptrSt->ptr;
   ptrSt++;
  }
  delete []st;
    
  return 100000;
}
